/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.mos6526;

import java.util.Arrays;
import libsidplay.common.CIAChipModel;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.components.pla.Bank;

public abstract class MOS6526
extends Bank {
    private static final String CREDITS = "MOS6526 (CIA) Emulation:\n\tCopyright (\u00a9) 2001-2004 Simon White <sidplay2@yahoo.com>\n\tCopyright (\u00a9) 2009 VICE Project\n\tCopyright (\u00a9) 2009-2010 Antti S. Lankila\n";
    private static final byte INTERRUPT_NONE = 0;
    private static final byte INTERRUPT_UNDERFLOW_A = 1;
    private static final byte INTERRUPT_UNDERFLOW_B = 2;
    private static final byte INTERRUPT_ALARM = 4;
    private static final byte INTERRUPT_SP = 8;
    private static final byte INTERRUPT_FLAG = 16;
    public static final int PRA = 0;
    public static final int PRB = 1;
    protected static final int DDRA = 2;
    protected static final int DDRB = 3;
    private static final int TAL = 4;
    private static final int TAH = 5;
    private static final int TBL = 6;
    private static final int TBH = 7;
    private static final int TOD_TEN = 8;
    private static final int TOD_SEC = 9;
    private static final int TOD_MIN = 10;
    private static final int TOD_HR = 11;
    private static final int SDR = 12;
    public static final int ICR = 13;
    protected static final int CRA = 14;
    protected static final int CRB = 15;
    protected final InterruptSource interruptSource;
    protected final Timer a;
    protected final Timer b;
    protected byte[] regs = new byte[16];
    protected byte sdr_out;
    protected boolean sdr_buffered;
    protected int sdr_count;
    protected final EventScheduler context;
    protected boolean m_todlatched;
    protected boolean m_todstopped;
    protected byte[] m_todclock = new byte[4];
    protected byte[] m_todalarm = new byte[4];
    protected byte[] m_todlatch = new byte[4];
    protected long m_todCycles;
    protected long m_todPeriod = 0xFFFFFFFFL;
    protected final Event m_todEvent = new Event("CIA Time of Day"){

        private byte byte2bcd(byte thebyte) {
            int num = thebyte & 0xFF;
            return (byte)((num / 10 << 4) + num % 10);
        }

        private byte bcd2byte(byte bcd) {
            return (byte)(10 * ((bcd & 0xF0) >> 4) + (bcd & 0xF));
        }

        @Override
        public void event() {
            MOS6526.this.m_todCycles = (MOS6526.this.regs[14] & 0x80) != 0 ? (MOS6526.this.m_todCycles += MOS6526.this.m_todPeriod * 5L) : (MOS6526.this.m_todCycles += MOS6526.this.m_todPeriod * 6L);
            MOS6526.this.context.schedule(this, MOS6526.this.m_todCycles >> 7);
            MOS6526.this.m_todCycles &= 0x7FL;
            if (!MOS6526.this.m_todstopped) {
                byte[] tod = MOS6526.this.m_todclock;
                int todPos = 0;
                int t = this.bcd2byte(tod[todPos]) + 1;
                tod[todPos++] = this.byte2bcd((byte)(t % 10));
                if (t >= 10) {
                    t = (byte)(this.bcd2byte(tod[todPos]) + 1);
                    tod[todPos++] = this.byte2bcd((byte)(t % 60));
                    if (t >= 60) {
                        t = (byte)(this.bcd2byte(tod[todPos]) + 1);
                        tod[todPos++] = this.byte2bcd((byte)(t % 60));
                        if (t >= 60) {
                            byte pm = (byte)(tod[todPos] & 0x80);
                            t = (byte)(tod[todPos] & 0x1F);
                            if (t == 17) {
                                pm = (byte)(pm ^ 0x80);
                            }
                            if (t == 18) {
                                t = 1;
                            } else if ((t = (byte)(t + 1)) == 10) {
                                t = 16;
                            }
                            t = (byte)(t & 0x1F);
                            tod[todPos] = (byte)(t | pm);
                        }
                    }
                }
                if (Arrays.equals(MOS6526.this.m_todalarm, MOS6526.this.m_todclock)) {
                    MOS6526.this.interruptSource.trigger((byte)4);
                }
            }
        }
    };

    protected MOS6526(EventScheduler ctx, CIAChipModel model) {
        this.context = ctx;
        this.interruptSource = model == CIAChipModel.MOS6526A ? new InterruptSource6526A() : new InterruptSource6526();
        this.a = new TimerA();
        this.b = new TimerB();
        this.reset();
    }

    public abstract void interrupt(boolean var1);

    public abstract void pulse();

    public abstract byte readPRA();

    public abstract byte readPRB();

    public abstract void writePRA(byte var1);

    public abstract void writePRB(byte var1);

    public void setFlag(boolean flag) {
        if (flag) {
            this.interruptSource.trigger((byte)16);
        }
    }

    public void reset() {
        this.a.reset();
        this.b.reset();
        this.sdr_out = 0;
        this.sdr_count = 0;
        this.sdr_buffered = false;
        this.interruptSource.reset();
        Arrays.fill(this.regs, (byte)0);
        Arrays.fill(this.m_todclock, (byte)0);
        Arrays.fill(this.m_todalarm, (byte)0);
        Arrays.fill(this.m_todlatch, (byte)0);
        this.m_todlatched = false;
        this.m_todstopped = true;
        this.m_todclock[3] = 1;
        this.m_todCycles = 0L;
        this.context.schedule(this.m_todEvent, 0L, Event.Phase.PHI1);
    }

    @Override
    public final byte read(int addr) {
        this.a.syncWithCpu();
        this.a.wakeUpAfterSyncWithCpu();
        this.b.syncWithCpu();
        this.b.wakeUpAfterSyncWithCpu();
        switch (addr &= 0xF) {
            case 0: {
                return (byte)(this.readPRA() & (this.regs[0] | ~this.regs[2]));
            }
            case 1: {
                byte data = (byte)(this.readPRB() & (this.regs[1] | ~this.regs[3]));
                this.pulse();
                if ((this.regs[14] & 2) != 0) {
                    data = (byte)(data & 0xBF);
                    if ((this.regs[14] & 4) != 0 ? this.a.getPbToggle() : (this.a.state & Integer.MIN_VALUE) != 0) {
                        data = (byte)(data | 0x40);
                    }
                }
                if ((this.regs[15] & 2) != 0) {
                    data = (byte)(data & 0x7F);
                    if ((this.regs[15] & 4) != 0 ? this.b.getPbToggle() : (this.b.state & Integer.MIN_VALUE) != 0) {
                        data = (byte)(data | 0x80);
                    }
                }
                return data;
            }
            case 4: {
                return (byte)(this.a.getTimer() & 0xFF);
            }
            case 5: {
                return (byte)(this.a.getTimer() >> 8);
            }
            case 6: {
                return (byte)(this.b.getTimer() & 0xFF);
            }
            case 7: {
                return (byte)(this.b.getTimer() >> 8);
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (!this.m_todlatched) {
                    System.arraycopy(this.m_todclock, 0, this.m_todlatch, 0, 4);
                }
                if (addr == 8) {
                    this.m_todlatched = false;
                }
                if (addr == 11) {
                    this.m_todlatched = true;
                }
                return this.m_todlatch[addr - 8];
            }
            case 13: {
                return this.interruptSource.clear();
            }
            case 14: {
                return (byte)(this.regs[14] & 0xEE | this.a.state & 1);
            }
            case 15: {
                return (byte)(this.regs[15] & 0xEE | this.b.state & 1);
            }
        }
        return this.regs[addr];
    }

    @Override
    public final void write(int addr, byte data) {
        this.a.syncWithCpu();
        this.b.syncWithCpu();
        byte oldData = this.regs[addr &= 0xF];
        this.regs[addr] = data;
        switch (addr) {
            case 0: 
            case 2: {
                this.writePRA((byte)(this.regs[0] | ~this.regs[2]));
                break;
            }
            case 1: {
                this.pulse();
            }
            case 3: {
                this.writePRB((byte)(this.regs[1] | ~this.regs[3]));
                break;
            }
            case 4: {
                this.a.setLatchLow(data);
                break;
            }
            case 6: {
                this.b.setLatchLow(data);
                break;
            }
            case 5: {
                this.a.setLatchHigh(data);
                break;
            }
            case 7: {
                this.b.setLatchHigh(data);
                break;
            }
            case 11: {
                data = (byte)(data & 0x9F);
                if ((data & 0x1F) == 18 && (this.regs[15] & 0x80) == 0) {
                    data = (byte)(data ^ 0x80);
                }
            }
            case 8: 
            case 9: 
            case 10: {
                if ((this.regs[15] & 0x80) != 0) {
                    this.m_todalarm[addr - 8] = data;
                } else {
                    if (addr == 8) {
                        this.m_todstopped = false;
                    }
                    if (addr == 11) {
                        this.m_todstopped = true;
                    }
                    this.m_todclock[addr - 8] = data;
                }
                if (this.m_todstopped || !Arrays.equals(this.m_todalarm, this.m_todclock)) break;
                this.interruptSource.trigger((byte)4);
                break;
            }
            case 12: {
                if ((this.regs[14] & 0x40) == 0) break;
                this.sdr_buffered = true;
                break;
            }
            case 13: {
                if ((data & 0x80) != 0) {
                    this.interruptSource.setEnabled(data);
                    break;
                }
                this.interruptSource.clearEnabled(data);
                break;
            }
            case 14: 
            case 15: {
                boolean start;
                Timer t = addr == 14 ? this.a : this.b;
                boolean bl = start = (data & 1) != 0 && (oldData & 1) == 0;
                if (start) {
                    t.setPbToggle(true);
                }
                if (addr == 15) {
                    t.setControlRegister((byte)(data | (data & 0x40) >> 1));
                    break;
                }
                t.setControlRegister(data);
                break;
            }
        }
        this.a.wakeUpAfterSyncWithCpu();
        this.b.wakeUpAfterSyncWithCpu();
    }

    public static final String credits() {
        return CREDITS;
    }

    public final void setDayOfTimeRate(double clock) {
        this.m_todPeriod = (long)(clock * 128.0);
    }

    protected final class InterruptSource6526A
    extends InterruptSource {
        protected InterruptSource6526A() {
        }

        @Override
        protected void trigger(byte interruptMask) {
            super.trigger(interruptMask);
            if ((this.icr & this.idr) != 0 && (this.idr & 0xFFFFFF80) == 0) {
                this.idr = (byte)(this.idr | 0xFFFFFF80);
                MOS6526.this.interrupt(true);
            }
        }

        @Override
        protected byte clear() {
            if ((this.idr & 0xFFFFFF80) != 0) {
                MOS6526.this.interrupt(false);
            }
            return super.clear();
        }

        @Override
        public void event() {
            throw new RuntimeException("6526A event called unexpectedly");
        }
    }

    protected final class InterruptSource6526
    extends InterruptSource {
        private boolean scheduled;

        protected InterruptSource6526() {
        }

        @Override
        protected void trigger(byte interruptMask) {
            super.trigger(interruptMask);
            if ((this.icr & this.idr) != 0 && (this.idr & 0xFFFFFF80) == 0) {
                this.schedule();
            }
        }

        private void schedule() {
            if (!this.scheduled) {
                MOS6526.this.context.schedule(this, 1L, Event.Phase.PHI1);
                this.scheduled = true;
            }
        }

        @Override
        protected byte clear() {
            if (this.scheduled) {
                MOS6526.this.context.cancel(this);
                this.scheduled = false;
            }
            if ((this.idr & 0xFFFFFF80) != 0) {
                MOS6526.this.interrupt(false);
            }
            return super.clear();
        }

        @Override
        public void event() {
            this.idr = (byte)(this.idr | 0xFFFFFF80);
            MOS6526.this.interrupt(true);
            this.scheduled = false;
        }

        @Override
        public void reset() {
            super.reset();
            this.scheduled = false;
        }
    }

    protected abstract class InterruptSource
    extends Event {
        protected static final byte INTERRUPT_REQUEST = -128;
        protected byte icr;
        protected byte idr;

        public InterruptSource() {
            super("CIA Interrupt");
        }

        protected void trigger(byte interruptMask) {
            this.idr = (byte)(this.idr | interruptMask);
        }

        protected byte clear() {
            byte old = this.idr;
            this.idr = 0;
            return old;
        }

        public void reset() {
            this.idr = 0;
            this.icr = 0;
            MOS6526.this.context.cancel(this);
        }

        public void setEnabled(byte interruptMask) {
            this.icr = (byte)(this.icr | interruptMask & 0x7F);
            this.trigger((byte)0);
        }

        public void clearEnabled(byte interruptMask) {
            this.icr = (byte)(this.icr & ~interruptMask);
        }
    }

    private final class TimerA
    extends Timer {
        private final Event bTick;

        public TimerA() {
            super("CIA A");
            this.bTick = Event.of("CIA B counts A", event -> {
                MOS6526.this.b.syncWithCpu();
                MOS6526.this.b.state |= 4;
                MOS6526.this.b.wakeUpAfterSyncWithCpu();
            });
        }

        @Override
        public void serialPort() {
            if ((MOS6526.this.regs[14] & 0x40) != 0) {
                if (MOS6526.this.sdr_count != 0 && --MOS6526.this.sdr_count == 0) {
                    MOS6526.this.interruptSource.trigger((byte)8);
                }
                if (MOS6526.this.sdr_count == 0 && MOS6526.this.sdr_buffered) {
                    MOS6526.this.sdr_out = MOS6526.this.regs[12];
                    MOS6526.this.sdr_buffered = false;
                    MOS6526.this.sdr_count = 16;
                }
            }
        }

        @Override
        public void underFlow() {
            MOS6526.this.interruptSource.trigger((byte)1);
            if ((MOS6526.this.regs[15] & 0x41) == 65 && (MOS6526.this.b.state & 1) != 0) {
                MOS6526.this.context.schedule(this.bTick, 0L, Event.Phase.PHI2);
            }
        }
    }

    protected abstract class Timer
    extends Event {
        protected static final int CIAT_CR_START = 1;
        protected static final int CIAT_STEP = 4;
        protected static final int CIAT_CR_ONESHOT = 8;
        protected static final int CIAT_CR_FLOAD = 16;
        protected static final int CIAT_PHI2IN = 32;
        protected static final int CIAT_CR_MASK = 57;
        protected static final int CIAT_COUNT2 = 256;
        protected static final int CIAT_COUNT3 = 512;
        protected static final int CIAT_ONESHOT0 = 2048;
        protected static final int CIAT_ONESHOT = 524288;
        protected static final int CIAT_LOAD1 = 4096;
        protected static final int CIAT_LOAD = 0x100000;
        protected static final int CIAT_OUT = Integer.MIN_VALUE;
        protected int state;
        protected byte lastControlValue;
        protected short timer;
        protected short latch;
        protected boolean pbToggle;
        protected long ciaEventPauseTime;
        private final Event cycleSkippingEvent;

        public Timer(String eventName) {
            super(eventName);
            this.cycleSkippingEvent = Event.of("Skip CIA clock decrement cycles", event -> {
                long elapsed = MOS6526.this.context.getTime(Event.Phase.PHI1) - this.ciaEventPauseTime;
                this.ciaEventPauseTime = 0L;
                this.timer = (short)((long)this.timer - elapsed);
                this.event();
            });
        }

        public final void setControlRegister(byte cr) {
            this.state &= 0xFFFFFFC6;
            this.state |= cr & 0x39 ^ 0x20;
            this.lastControlValue = cr;
        }

        public final int getTimer() {
            return this.timer;
        }

        public final boolean getPbToggle() {
            return this.pbToggle;
        }

        public final void setPbToggle(boolean state) {
            this.pbToggle = state;
        }

        public final void setLatchHigh(byte high) {
            this.latch = (short)(this.latch & 0xFF | (high & 0xFF) << 8);
            if ((this.state & 0x100000) != 0 || (this.state & 1) == 0) {
                this.timer = this.latch;
            }
        }

        public final void setLatchLow(byte low) {
            this.latch = (short)(this.latch & 0xFF00 | low & 0xFF);
            if ((this.state & 0x100000) != 0) {
                this.timer = (short)(this.timer & 0xFF00 | low & 0xFF);
            }
        }

        public final void reset() {
            MOS6526.this.context.cancel(this);
            this.latch = (short)-1;
            this.timer = (short)-1;
            this.pbToggle = false;
            this.state = 0;
            this.ciaEventPauseTime = 0L;
            MOS6526.this.context.schedule(this, 1L, Event.Phase.PHI1);
        }

        public final void syncWithCpu() {
            if (this.ciaEventPauseTime > 0L) {
                MOS6526.this.context.cancel(this.cycleSkippingEvent);
                long elapsed = MOS6526.this.context.getTime(Event.Phase.PHI2) - this.ciaEventPauseTime;
                if (elapsed >= 0L) {
                    this.timer = (short)((long)this.timer - elapsed);
                    this.clock();
                }
            }
            if (this.ciaEventPauseTime == 0L) {
                MOS6526.this.context.cancel(this);
            }
            this.ciaEventPauseTime = -1L;
        }

        public final void wakeUpAfterSyncWithCpu() {
            this.ciaEventPauseTime = 0L;
            MOS6526.this.context.schedule(this, 0L, Event.Phase.PHI1);
        }

        @Override
        public void event() {
            this.clock();
            this.reschedule();
        }

        public void clock() {
            if (this.timer != 0 && (this.state & 0x200) != 0) {
                this.timer = (short)(this.timer - 1);
            }
            int adj = this.state & 0x29;
            if ((this.state & 0x21) == 33) {
                adj |= 0x100;
            }
            if ((this.state & 0x100) != 0 || (this.state & 5) == 5) {
                adj |= 0x200;
            }
            this.state = adj |= (this.state & 0x1818) << 8;
            if (this.timer == 0 && (this.state & 0x200) != 0) {
                this.state |= 0x80100000;
                if ((this.state & 0x80800) != 0) {
                    this.state &= 0xFFFFFEFE;
                }
                boolean toggle = (this.lastControlValue & 6) == 6;
                this.pbToggle = toggle && !this.pbToggle;
                this.serialPort();
                this.underFlow();
            }
            if ((this.state & 0x100000) != 0) {
                this.timer = this.latch;
                this.state &= 0xFFFFFDFF;
            }
        }

        private final void reschedule() {
            int unwanted = -2146430960;
            if ((this.state & 0x80101010) != 0) {
                MOS6526.this.context.schedule(this, 1L);
                return;
            }
            if ((this.state & 0x200) != 0) {
                int wanted = 801;
                if ((this.timer & 0xFFFF) > 2 && (this.state & 0x321) == 801) {
                    this.ciaEventPauseTime = MOS6526.this.context.getTime(Event.Phase.PHI1) + 1L;
                    MOS6526.this.context.schedule(this.cycleSkippingEvent, this.timer - 1 & 0xFFFF);
                    return;
                }
                MOS6526.this.context.schedule(this, 1L);
                return;
            }
            int unwanted1 = 33;
            int unwanted2 = 5;
            if ((this.state & 0x21) == 33 || (this.state & 5) == 5) {
                MOS6526.this.context.schedule(this, 1L);
                return;
            }
            this.ciaEventPauseTime = -1L;
        }

        public abstract void serialPort();

        public abstract void underFlow();
    }

    private final class TimerB
    extends Timer {
        public TimerB() {
            super("CIA B");
        }

        @Override
        public void serialPort() {
        }

        @Override
        public void underFlow() {
            MOS6526.this.interruptSource.trigger((byte)2);
        }
    }
}

